/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.features.terrain.caves.EndCaveFeature;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class RoundCaveFeature
extends EndCaveFeature {
    @Override
    protected Set<class_2338> generate(class_5281 world, class_2338 center, int radius, class_5819 random) {
        OpenSimplexNoise noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)center.method_10263(), (int)center.method_10260()));
        int x1 = center.method_10263() - radius - 5;
        int z1 = center.method_10260() - radius - 5;
        int x2 = center.method_10263() + radius + 5;
        int z2 = center.method_10260() + radius + 5;
        int y1 = MHelper.floor((double)((double)center.method_10264() - (double)(radius + 5) / 1.6));
        int y2 = MHelper.floor((double)((double)center.method_10264() + (double)(radius + 5) / 1.6));
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        int dx = x2 - x1 + 1;
        int dz = z2 - z1 + 1;
        int count = dx * dz;
        Set blocks = Sets.newConcurrentHashSet();
        IntStream.range(0, count).parallel().forEach(index -> {
            class_2338.class_2339 bpos = new class_2338.class_2339();
            int x = index % dx + x1;
            int z = index / dx + z1;
            bpos.method_33097(x);
            bpos.method_33099(z);
            int xsq = MHelper.sqr((int)(x - center.method_10263()));
            int zsq = MHelper.sqr((int)(z - center.method_10260()));
            int dxz = xsq + zsq;
            for (int y = y1; y <= y2; ++y) {
                double r;
                int ysq = (int)MHelper.sqr((double)((double)(y - center.method_10264()) * 1.6));
                double dist = dxz + ysq;
                if (!(dist < (r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr) * r)) continue;
                bpos.method_33098(y);
                class_2680 state = world.method_8320((class_2338)bpos);
                if (!this.isReplaceable(state) || this.isWaterNear(world, (class_2338)bpos)) continue;
                blocks.add(bpos.method_10062());
                while (state.method_26207().equals(class_3614.field_15923)) {
                    bpos.method_33098(bpos.method_10264() + 1);
                    state = world.method_8320((class_2338)bpos);
                }
                bpos.method_33098(y - 1);
                while (state.method_26207().equals(class_3614.field_15923)) {
                    bpos.method_33098(bpos.method_10264() - 1);
                    state = world.method_8320((class_2338)bpos);
                }
            }
        });
        blocks.forEach(bpos -> BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bpos, (class_2680)CAVE_AIR));
        return blocks;
    }

    private boolean isReplaceable(class_2680 state) {
        return state.method_26164(CommonBlockTags.GEN_END_STONES) || state.method_26207().method_15800() || state.method_26207().equals(class_3614.field_15935) || state.method_26207().equals(class_3614.field_15923);
    }
}

